import type { FC } from 'react';
import { useFocus } from 'tachyon-tv-nav';
import { Card } from './Card';

type FocusableCardProps = {
  className?: string;
  focusIndex: number;
};

export const FocusableCard: FC<FocusableCardProps> = ({
  className,
  focusIndex,
}) => {
  const { focusId, focused } = useFocus(focusIndex);
  return (
    <Card
      className={className}
      focus={focused}
      focusId={focusId}
      focusIndex={focusIndex}
    />
  );
};
