import type { FC } from 'react';
import { useRef, useState } from 'react';
import { HorizontalNav } from 'tachyon-tv-nav';
import {
  AlignItems,
  Background,
  Button,
  ButtonType,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  Layout,
  Tower,
  TowerChildWidth,
  TowerGutter,
} from 'twitch-core-ui';
import { FocusableCard } from '../FocusableCard';

type ShelfProps = {
  focusIndex: number;
};

export const SimpleShelf: FC<ShelfProps> = ({ focusIndex }) => {
  const [cardCount, setCardCount] = useState(5);

  const cards = Array.from({ length: cardCount }).map((_, i) => {
    return <FocusableCard focusIndex={i} key={i} />;
  });

  const renderCount = useRef(0);
  renderCount.current++;

  return (
    <>
      <Layout
        alignItems={AlignItems.Center}
        display={Display.Flex}
        flexDirection={FlexDirection.Row}
      >
        <CoreText fontSize={FontSize.Size3}>
          {`Shelf: Renders ${renderCount.current}`}
        </CoreText>
        <Layout padding={{ left: 1 }}>
          <Button
            onClick={() => setCardCount((c) => c + 1)}
            variant={ButtonType.Secondary}
          >
            Add Card
          </Button>
        </Layout>
        <Layout padding={{ left: 1 }}>
          <Button
            disabled={cardCount === 0}
            onClick={() => setCardCount((c) => c - 1)}
            variant={ButtonType.Secondary}
          >
            Remove Card
          </Button>
        </Layout>
      </Layout>
      <Layout background={Background.Accent} margin={{ y: 1 }}>
        <HorizontalNav elementCount={cardCount} focusIndex={focusIndex}>
          <Tower
            childWidth={TowerChildWidth.Medium}
            gutterSize={TowerGutter.Small}
            noWrap
          >
            {cards}
          </Tower>
        </HorizontalNav>
      </Layout>
    </>
  );
};
