import type { FC } from 'react';
import { useState } from 'react';
import styled from 'styled-components';
import { getCurrentUserInBrowser } from 'tachyon-auth';
import { CoreUiSsrRoot } from 'tachyon-more-ui';
import {
  Button,
  Display,
  FlexDirection,
  Input,
  InputType,
  Layout,
} from 'twitch-core-ui';
import type { ChatConsumerProps } from '../ChatConsumer';
import { ChatConsumer } from '../ChatConsumer';

const ScInputContainer = styled.div`
  width: 300px;
`;

export const ChatController: FC = () => {
  const { authorizationToken } = getCurrentUserInBrowser();
  const [channel, setChannel] = useState<string>('');
  const [currentUser, setCurrentUser] =
    useState<ChatConsumerProps['currentUser']>(null);

  const [loadChat, setLoadChat] = useState(false);

  return (
    <CoreUiSsrRoot appRootElementId="root">
      <Layout display={Display.Flex} flexDirection={FlexDirection.Row}>
        <ScInputContainer>
          {authorizationToken && (
            <Input
              onChange={(e) =>
                setCurrentUser({
                  authToken: authorizationToken,
                  login: e.currentTarget.value,
                })
              }
              placeholder="Current User Login"
              type={InputType.Text}
            />
          )}
          <Input
            onChange={(e) => setChannel(e.currentTarget.value)}
            placeholder="Chat Channel Login"
            type={InputType.Text}
          />
          <Button
            disabled={channel === ''}
            onClick={() => setLoadChat((s) => !s)}
          >
            {loadChat ? 'Change Chat' : 'Load Chat'}
          </Button>
        </ScInputContainer>
        {loadChat && (
          <div>
            <ChatConsumer channel={channel} currentUser={currentUser} />
          </div>
        )}
      </Layout>
    </CoreUiSsrRoot>
  );
};
