# Tachyon Packages

Within this folder are a number of packages that are consumable within Tachyon
or any other external project that utilizes NPM. All Tachyon packages are built
with [Tachyon Package Builder](./tachyon-core/package-builder/README.md).

## Consuming Tachyon Packages

By default these packages are consumable through
[Twitch's internal NPM](https://wiki.twitch.com/display/ENG/Publishing+packages+to+internal+NPM)
mirror:

```
$ yarn add <PACKAGE_NAME>
```

## Creating A Package

Use Tachyon's template project: [Feinberg](../templates/feinberg/README.md).

Where "<PACKAGE_NAME>" is the value of the "name" field in the package's
`package.json` file.

## Rebuilding Packages

From the root of Tachyon, run the following to rebuild all packages:

```sh
$ yarn build
```

## Local Package Development And Testing

Once you're satisfied with your package changes, within each package that you
have changed, run:

```sh
$ yarn build
```

After the command above runs successfully, your are able to consume the changes
within other Tachyon applications and packages instantly.

Packages also support a watch mode for re-building as a result of changes within
the package or when other packages are re-built within Tachyon. Within each
package, run:

```sh
yarn build:watch
```

To run linting / prettier, in each package:

```sh
yarn fix
```

## Publishing Packages To NPM

Since [lerna](https://lernajs.io/) coordinates publishing of all the packages
within the monorepo, ask the Emerging Platforms team when you need a package
published.

## Package Examples

See the `package-examples` folder at the root of Tachyon for sample
implementations of various packages. To create a new package-example for a
package, use [Feinberg](../templates/feinberg/README.md).

## Using Localization In Pacakges

It is possible to use localization in packages and applications that utilize
`tachyon-intl`. Follow the guide and setting
[package localization](./packages/tachyon-core/intl/README.md) in
`tachyon-intl`.
