import {
  createGlobalStyle,
  staticTokenRule,
  themeTokenRule,
} from 'twitch-core-ui-utils-styled-components';

export const SCtheme = createGlobalStyle`
/* Pikaday */
/* Copyright © 2014 David Bushell | BSD & MIT license | http://dbushell.com/ */

/* stylelint-disable no-descending-specificity */
:root {
  --pd-day-disabled-bg: transparent;
  --pd-button-radius: 2px;
  --pd-picker-border: ${staticTokenRule('color-hinted-grey-12')};
  --pd-picker-shadow: rgba(--black, 0.2);
  --pd-th-color: ${staticTokenRule('color-hinted-grey-6')};
  --pd-day-selected-bg: ${staticTokenRule('color-twitch-purple-8')};
  --pd-day-selected-color: --white;
  --pd-day-selected-hover-bg: ${staticTokenRule('color-twitch-purple-7')};
  --pd-day-selected-shadow: ${staticTokenRule('color-twitch-purple-6')};
  --pd-week-color: ${staticTokenRule('color-hinted-grey-13')};
  --pd-is-inrange-bg: ${staticTokenRule('color-twitch-purple-12')};
  --pd-is-inrange-color: ${staticTokenRule('color-twitch-purple-6')};
  --pd-is-startrange-bg: ${staticTokenRule('color-twitch-purple-7')};
  --pd-is-startrange-color: --white;
  --pd-is-endrange-bg: ${staticTokenRule('color-twitch-purple-7')};
  --pd-is-endrange-color: --white;
}

.inline.pika-single {
  background: ${themeTokenRule('color-background-base')};
  color: ${themeTokenRule('color-text-base')};

  display: block;
  font-family: ${staticTokenRule('font-base')};
  position: relative !important;
  width: 260px;
  z-index: ${staticTokenRule('z-index-above')};


  &.is-bound {
    box-shadow: 0 2px 6px var(--pd-picker-shadow);
  }
}

.inline .pika-label {
  background: var(--pd-title-bg-token);
  color: ${themeTokenRule('color-text-base')};
  font-size: ${staticTokenRule('font-size-5')};
  font-weight: ${staticTokenRule('font-weight-bold')};
  line-height: 20px;
  z-index: ${staticTokenRule('z-index-above')};

  &:hover,
  &:active,
  &:focus {
    background: ${themeTokenRule('color-background-interactable-alpha-hover')};
  }
}

.inline .pika-title {
  padding-bottom: 0.5rem;

  .pika-label {
    line-height: 30px;
    padding-left: ${staticTokenRule('space-05')};
    padding-right: ${staticTokenRule('space-05')};
  }

  select {
    z-index: ${staticTokenRule('z-index-above')};
  }
}

.inline .pika-next,
.inline .is-rtl .pika-prev {
  &::after {
    border-left: 6px solid ${themeTokenRule('color-text-link')};
  }
}

.inline .pika-prev,
.inline .is-rtl .pika-next {
  &::after {
    border-right: 6px solid ${themeTokenRule('color-text-link')};
  }
}

.inline .pika-prev,
.inline .pika-next {
  &:hover,
  &:active,
  &:focus {
    background-color: ${themeTokenRule(
      'color-background-interactable-alpha-hover',
    )};
    opacity: 1;
  }
}


.inline .pika-select {
  display: inline;
}

.pika-table {
  border: 0;
  border-collapse: collapse;
  border-spacing: 0;
  width: 100%;

  th,
  td {
    padding: 0;
    width: 14.2857142857%;
  }

  th {
    color: var(--pd-th-color);
    font-size: ${staticTokenRule('font-size-6')};
    font-weight: ${staticTokenRule('font-weight-bold')};
  }

  abbr {
    cursor: default;
    text-decoration: none;
  }
}


.inline .pika-button {
  background: ${themeTokenRule('color-background-base')};
  border-radius: var(--pd-button-radius);
  color: ${themeTokenRule('color-text-button-text')};

  font-size: ${staticTokenRule('font-size-6')};
  line-height: 15px;
  text-align: center;
  transition: background-color 0.15s ease-in-out;

  .is-today & {
    border-radius: var(--pd-button-radius);
    box-shadow: inset 0 0 0 2px ${themeTokenRule('color-border-base')};
  }

  .is-selected & {
    background: var(--pd-day-selected-bg);
    color: var(--pd-day-selected-color);
  }

  .is-disabled &,
  .is-outside-current-month & {
    background: var(--pd-day-disabled-bg);
    color: rgba(${themeTokenRule('color-text-button-disabled')}, 0.5);
    cursor: default;
    pointer-events: none;
  }

  &:hover {
    background: ${themeTokenRule('color-background-interactable-alpha-hover')};
    color: ${themeTokenRule('color-text-link')};
  }

  .is-selected:hover & {
    background: var(--pd-day-selected-hover-bg);
    color: var(--pd-day-selected-color);
  }
}

.inline .is-inrange .pika-button {
  background: ${themeTokenRule('color-background-interactable-selected')};
  border-radius: ${staticTokenRule('border-radius-none')};
  color: ${themeTokenRule('color-text-interactable-selected')};

  &:hover {
    background: rgba(token(${themeTokenRule(
      'color-background-interactable-hover',
    )}), 0.5);
  }
}

.inline .pika-week {
    color: var(--pd-week-color);
    font-size: ${staticTokenRule('font-size-7')};
}


.inline .is-startrange .pika-button {
  background: var(--pd-is-startrange-bg);
  border-radius: var(--pd-button-radius);
  box-shadow: none;
  color: var(--pd-is-startrange-color);

  &:hover,
  &:active,
  &:focus {
    background: var(--pd-is-startrange-bg);
    color: var(--pd-is-startrange-color);
  }
}

.inline .is-endrange .pika-button {
  background: var(--pd-is-endrange-bg);
  border-radius: var(--pd-button-radius);
  box-shadow: none;
  color: var(--pd-is-endrange-color);

  &:hover,
  &:active,
  &:focus {
    background: var(--pd-is-endrange-bg);
    color: var(--pd-is-endrange-color);
  }
}
`;
