import { createMountWrapperFactory } from 'tachyon-test-utils';
import { DateRangePicker } from '../date-range-picker';
import { ShuffleWrapProps } from '../shuffle-wrap';
import { DATE_PICKER_TOGGLE_SELECTOR, DateRangeBar } from '.';

// prevent s-c console spam
jest.mock('../date-picker-lite', () => ({
  DatePickerLite: () => null,
}));

const startDate = new Date('1999-02-17T03:24:00');
const endDate = new Date('1999-02-25T03:24:00');

describe(DateRangeBar, () => {
  const setup = createMountWrapperFactory(DateRangeBar, () => ({
    interval: { end: endDate, start: startDate },
    onDateSelect: jest.fn(),
  }));

  /**
   * the default allowed range is something in the 1999-2000,
   * so any year out of that range will be an invalid range date
   */
  const setupOutOfRange = createMountWrapperFactory(DateRangeBar, () => ({
    interval: {
      end: new Date('2019-12-17T03:24:00'),
      start: new Date('2018-12-17T03:24:00'),
    },
    onDateSelect: jest.fn(),
  }));

  it('opens and closes the DateRangePicker after clicking toggle selector', () => {
    const { wrapper } = setup();
    wrapper.find(DATE_PICKER_TOGGLE_SELECTOR).hostNodes().simulate('click');
    expect(wrapper.find(DateRangePicker)).toExist();

    wrapper.find(DATE_PICKER_TOGGLE_SELECTOR).hostNodes().simulate('click');
    expect(wrapper.find(DateRangePicker)).not.toExist();
  });

  it('does not update the date when the interval is not in a queryable range', () => {
    const { props, wrapper } = setupOutOfRange();
    wrapper.find(ShuffleWrapProps).simulate('click');
    expect(props.onDateSelect).not.toHaveBeenCalled();
  });
});
