import { endOfDay } from 'date-fns';
import type { Interval } from '../../models';

/**
 * Determine if an interval is valid and ends before today.
 */
export function isInQueryableRange(
  interval: Interval,
  now: Date = new Date(),
): boolean {
  return interval.start <= interval.end && interval.end <= endOfDay(now);
}
