import { endOfDay } from 'date-fns';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { DatePickerLite } from '../date-picker-lite';
import { DateRangePickerPresets, PresetID } from '../date-range-picker-presets';
import {
  CANCEL_BUTTON_SELECTOR,
  COMMIT_BUTTON_SELECTOR,
  DateRangePicker,
} from '.';

describe(DateRangePicker, () => {
  const today = new Date('2001-01-01');

  const render = createShallowWrapperFactory(DateRangePicker, () => ({
    interval: { end: today, start: today },
    onCommit: jest.fn(),
    onDismiss: jest.fn(),
  }));

  it('changing the start date', () => {
    const { props, wrapper } = render();

    const newStart = new Date('2000-12-31;');
    wrapper.find(DatePickerLite).first().prop('onChange')(newStart);
    wrapper.find(COMMIT_BUTTON_SELECTOR).simulate('click');

    expect(props.onCommit).toHaveBeenCalledWith({
      end: today,
      id: PresetID.Custom,
      start: newStart,
    });
  });

  it('changing the end date', () => {
    const { props, wrapper } = render();

    const newEnd = new Date('2001-01-02');
    wrapper.find(DatePickerLite).last().prop('onChange')(newEnd);
    wrapper.find(COMMIT_BUTTON_SELECTOR).simulate('click');

    expect(props.onCommit).toHaveBeenCalledWith({
      end: endOfDay(newEnd),
      id: PresetID.Custom,
      start: today,
    });
  });

  it('canceling change', () => {
    const { props, wrapper } = render();

    const newStart = new Date('2000-12-31;');
    wrapper.find(DatePickerLite).first().prop('onChange')(newStart);
    wrapper.find(CANCEL_BUTTON_SELECTOR).simulate('click');

    expect(props.onCommit).not.toHaveBeenCalled();
  });

  it('updates from the presets trigger onCommit', () => {
    const { props, wrapper } = render();

    wrapper.find(DateRangePickerPresets).first().prop('onChange')({
      end: new Date(),
      id: PresetID.Custom,
      start: new Date(),
    });

    expect(props.onCommit).toHaveBeenCalled();
  });
});
