import type { FC, ReactNode } from 'react';
import { useEffect, useState } from 'react';
import { InjectLayout } from 'twitch-core-ui';
import { ClickOutDetector } from '../click-out-detector';

interface DisclosureProps {
  children: (callbacks: Callbacks) => ReactNode;
  control: (callbacks: Callbacks) => ReactNode;
  onOpen?: () => void;
}

export interface Callbacks {
  close: () => void;
  toggle: () => void;
}

export const Disclosure: FC<DisclosureProps> = ({
  children,
  control,
  onOpen,
}) => {
  const [isDisclosed, setIsDisclosed] = useState(false);

  useEffect(() => {
    if (isDisclosed) {
      if (onOpen) {
        onOpen();
      }
    }
  }, [isDisclosed, onOpen]);

  const toggle = (): void => {
    setIsDisclosed(!isDisclosed);
  };

  const close = (): void => {
    setIsDisclosed(false);
  };

  const callbacks: Callbacks = { close, toggle };

  return (
    <InjectLayout fullHeight>
      <ClickOutDetector onClickOut={close}>
        {control(callbacks)}
        {isDisclosed && children(callbacks)}
      </ClickOutDetector>
    </InjectLayout>
  );
};

Disclosure.displayName = 'Disclosure';
