import { act } from 'react-dom/test-utils';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { ClickOutDetector } from '../click-out-detector';
import type { Callbacks } from '.';
import { Disclosure } from '.';

describe(Disclosure, () => {
  const control = ({ toggle }: Callbacks) => (
    <button id="trigger" onClick={toggle}>
      Trigger
    </button>
  );

  const children = ({ close }: Callbacks) => (
    <button id="child" onClick={close}>
      Child
    </button>
  );
  const setup = createMountWrapperFactory(Disclosure, () => ({
    children,
    control,
    onOpen: jest.fn(),
  }));

  it('children are hidden at first', () => {
    const { wrapper } = setup();

    expect(wrapper.find('#child')).toHaveLength(0);
  });

  it('children are disclosed after clicking', () => {
    const { wrapper } = setup();
    wrapper.find('#trigger').simulate('click');

    expect(wrapper.find('#child')).toHaveLength(1);
  });

  it('children can close the disclosed content', () => {
    const { wrapper } = setup();
    wrapper.find('#trigger').simulate('click');
    wrapper.find('#child').simulate('click');

    expect(wrapper.find('#child')).toHaveLength(0);
  });

  it('closes on global click via the ClickOutDetector', () => {
    const { wrapper } = setup();
    wrapper.find('#trigger').simulate('click');

    act(() => {
      wrapper
        .find(ClickOutDetector)
        .props()
        .onClickOut({} as MouseEvent);
    });

    wrapper.update();

    expect(wrapper.find('#child')).toHaveLength(0);
  });

  it('calls onOpen when opened via controls', () => {
    const { wrapper } = setup();
    wrapper.find('#trigger').simulate('click');

    const onOpen = wrapper.find(Disclosure).props().onOpen;

    expect(onOpen).toHaveBeenCalled();
  });
});
