import type { FC } from 'react';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ShuffleWrapProps } from '.';

const EmptyNode: FC<{}> = (props) => <div>{props.children}</div>;

describe(ShuffleWrapProps, () => {
  const shallow = createShallowWrapperFactory(ShuffleWrapProps, () => ({
    children: EmptyNode,
    onClickNext: jest.fn(),
    onClickPrevious: jest.fn(),
  }));

  it('responds to button click', () => {
    const { props, wrapper } = shallow();
    wrapper.find('ShuffleWrapSquareComponent').first().simulate('click');

    expect(props.onClickPrevious).toHaveBeenCalled();

    wrapper.find('ShuffleWrapSquareComponent').last().simulate('click');

    expect(props.onClickNext).toHaveBeenCalled();
  });
});
