import type { FC, MouseEventHandler } from 'react';
import {
  AttachedTooltip,
  Display,
  Interactable,
  InteractableType,
  Layout,
  TooltipAlign,
  TooltipDirection,
} from 'twitch-core-ui';

interface TimeInteractableProps {
  disabled?: boolean;
  disabledMessage?: string;
  displayValue?: string;
  onClick: MouseEventHandler<HTMLElement>;
  refDelegate?: ((e: HTMLDivElement) => void) | undefined;
  selected?: boolean;
  value: string;
}

export const TimeInteractable: FC<TimeInteractableProps> = ({
  disabled,
  disabledMessage,
  displayValue,
  onClick,
  refDelegate,
  selected,
  value,
}) => {
  const optionElement = (
    <Interactable
      data-display-value={displayValue}
      data-value={value}
      // TODO EXACT-TYPES: cast to boolean because display/hover types are Optional(boolean) instead of Optional(boolean | undefined)
      disabled={disabled as boolean}
      hover={selected as boolean}
      onClick={onClick}
      variant={InteractableType.Alpha}
    >
      <Layout padding={0.5} ref={refDelegate}>
        {displayValue || value}
      </Layout>
    </Interactable>
  );

  if (disabled && disabledMessage) {
    return (
      <AttachedTooltip
        align={TooltipAlign.Left}
        direction={TooltipDirection.Bottom}
        display={Display.Flex}
        label={disabledMessage}
        width={130}
      >
        {optionElement}
      </AttachedTooltip>
    );
  }
  return optionElement;
};

TimeInteractable.displayName = 'TimeInteractable';
