import { useIntl } from 'tachyon-intl';

export const useNextMonthMessage = (): string => {
  const { formatMessage } = useIntl();
  return formatMessage('Next Month', 'DatePicker');
};

export const usePreviousMonthMessage = (): string => {
  const { formatMessage } = useIntl();
  return formatMessage('Previous Month', 'DatePicker');
};

export const useMonthNames = (): string[] => {
  const { formatDate } = useIntl();
  const months = [];

  for (let i = 0; i < 12; i++) {
    const date = new Date(2000, i);
    months.push(formatDate(date, { month: 'long' }));
  }

  return months;
};

export const useWeekdayNames = (format: 'long' | 'short'): string[] => {
  const { formatDate } = useIntl();
  const weekdays = [];

  for (let i = 0; i < 7; i++) {
    // Jan 2nd is Sunday
    const date = new Date(2000, 0, 2 + i);
    weekdays.push(formatDate(date, { weekday: format }));
  }

  return weekdays;
};
