import {
  DateAdjustmentType,
  getAdjustedDateFromCurrent,
  isValid,
  parseTimeStringToDate,
  parseTimeStringToTime,
} from '.';

describe('parseTimeStringToDate', () => {
  it('parses 12pm properly', () => {
    const date = parseTimeStringToDate('12:00pm');
    expect(date.getHours()).toBe(12);
    expect(date.getMinutes()).toBe(0);
  });

  it('parses 12am properly', () => {
    const date = parseTimeStringToDate('12:00am');
    expect(date.getHours()).toBe(0);
    expect(date.getMinutes()).toBe(0);
  });

  it('parses minutes', () => {
    const date = parseTimeStringToDate('12:38am');
    expect(date.getHours()).toBe(0);
    expect(date.getMinutes()).toBe(38);
  });

  it('parses 24 hr time', () => {
    const date1 = parseTimeStringToDate('23:59');
    expect(date1.getHours()).toBe(23);
    expect(date1.getMinutes()).toBe(59);

    const date2 = parseTimeStringToDate('4:20');
    expect(date2.getHours()).toBe(4);
    expect(date2.getMinutes()).toBe(20);

    const date3 = parseTimeStringToDate('12:44');
    expect(date3.getHours()).toBe(12);
    expect(date3.getMinutes()).toBe(44);

    const date4 = parseTimeStringToDate('00:00');
    expect(date4.getHours()).toBe(0);
    expect(date4.getMinutes()).toBe(0);
  });
});

describe('parseTimeStringToTime', () => {
  it('parses 12pm properly', () => {
    const time = parseTimeStringToTime('12:00pm');
    expect(time.hours).toBe(12);
    expect(time.minutes).toBe(0);
  });

  it('parses 12am properly', () => {
    const time = parseTimeStringToTime('12:00am');
    expect(time.hours).toBe(0);
    expect(time.minutes).toBe(0);
  });

  it('parses minutes', () => {
    const time = parseTimeStringToTime('12:38am');
    expect(time.hours).toBe(0);
    expect(time.minutes).toBe(38);
  });

  it('parses 24 hr time', () => {
    const time1 = parseTimeStringToTime('23:59');
    expect(time1.hours).toBe(23);
    expect(time1.minutes).toBe(59);

    const time2 = parseTimeStringToTime('4:20');
    expect(time2.hours).toBe(4);
    expect(time2.minutes).toBe(20);

    const time3 = parseTimeStringToTime('12:44');
    expect(time3.hours).toBe(12);
    expect(time3.minutes).toBe(44);

    const time4 = parseTimeStringToTime('00:00');
    expect(time4.hours).toBe(0);
    expect(time4.minutes).toBe(0);
  });

  describe('isValid', () => {
    it('handles hours between 0 and 23', () => {
      const time1 = { hours: 23, minutes: 0 };
      const time2 = { hours: 0, minutes: 0 };
      const time3 = { hours: 5, minutes: 0 };
      const time4 = { hours: 24, minutes: 0 };
      const time5 = { hours: -1, minutes: 0 };

      expect(isValid(time1)).toBe(true);
      expect(isValid(time2)).toBe(true);
      expect(isValid(time3)).toBe(true);
      expect(isValid(time4)).toBe(false);
      expect(isValid(time5)).toBe(false);
    });
  });

  describe('getAdjustedDateFromCurrent', () => {
    const testDays = 10;

    it('calculates prior date correctly', () => {
      const currDate = new Date();
      const priorDate = currDate.getDate() - testDays;
      expect(
        getAdjustedDateFromCurrent(testDays, DateAdjustmentType.Prior),
      ).toEqual(new Date(currDate.setDate(priorDate)));
    });

    it('calculates future date correctly', () => {
      const currDate = new Date();
      const futureDate = currDate.getDate() + testDays;
      expect(
        getAdjustedDateFromCurrent(testDays, DateAdjustmentType.Ahead),
      ).toEqual(new Date(currDate.setDate(futureDate)));
    });
  });
});
