// Returns the current time in UTC with the browsers timezone
// i.e. returns a date object with -7 hours for PST
export function newUTCDate(): Date {
  const now = new Date();
  return toUTCDate(now);
}

interface MinimumDate {
  getTime(): number;
  getTimezoneOffset(): number;
}

export function toUTC(now: MinimumDate): number {
  const localTime = now.getTime();
  const localOffset = now.getTimezoneOffset() * 60000;
  return localTime + localOffset;
}

// Creates a date with now's getTimezoneOffset
export function toUTCDate(now: MinimumDate): Date {
  return new Date(toUTC(now));
}

export function fromUTC(utcDate: MinimumDate): number {
  const utcTimestamp = utcDate.getTime();
  const localOffset = utcDate.getTimezoneOffset() * 60000;
  return utcTimestamp - localOffset;
}

// Takes a UTC date and converts it back to it's proper timezone date
export function fromUTCDate(utcDate: MinimumDate): Date {
  return new Date(fromUTC(utcDate));
}
