# Twitch Chat Client

A port of the old [tmi-js-client](https://git.xarth.tv/chat/tmi-js-client)
library, this library provides logic to support the connection between IRC Chat
and web clients.

See the [package-example](../../../package-examples/twitch-chat-client) for a
demo implementation.

## Contributing

1. Make a PR with your changes, ensure it passes CI.
1. Add the "Ready For Review" label & share it in #communications-web

## Building For Tachyon Consumers

Run `yarn build` or `yarn build:watch`. All consumers in Tachyon will instantly
pickup the change.

## Testing

Run `yarn test` or `yarn test:watch`.

## Publishing A New Version

Request a new version publish in #tachyon-lib-support.

## Logging Errors

There is a logging interface called TMILogger which can be found here:

- Interface in chat/twitch-chat-client
- Implementation in twilight/twilight

`TMILogger` implements the common logging interface in Twilight (Interface,
Implementation). It provides five client methods, each with no return value:

- debug: Same as console.debug()
- info: Same as console.info()
- warn: Same as console.warn()
- error: Same as console.error() but also tracked in Sentry
- trackAndWarn: Same as console.warn() but also sends an event to Spade. Accepts
  a Spade event name and params Object as the first args
