import { TMICommand } from './tmi-command';
import type { TMICommandRequest, TMICommandResponse } from './tmi-command-args';

export interface BanRequest extends TMICommandRequest {
  channel: string;
  reason: number;
  username: number;
}

export interface BanResponse extends TMICommandResponse {
  succeeded: boolean;
}

export class BanCommand extends TMICommand<BanRequest, BanResponse> {
  public getCommandText(data: BanRequest): Array<string> {
    return [`/ban ${data.username} ${data.reason}`];
  }
}
