import { TMICommand } from './tmi-command';
import type { TMICommandRequest, TMICommandResponse } from './tmi-command-args';

export interface CommercialRequest extends TMICommandRequest {
  seconds?: number;
}

export class CommercialCommand extends TMICommand<
  CommercialRequest,
  TMICommandResponse
> {
  public getCommandText(data: CommercialRequest): Array<string> {
    return [`/commercial ${data.seconds || 30}`];
  }
}
