import { mockTMIConnection, mockTMISession, mockWebSocket } from '../tests';
import { ConnectCommand } from './connect';

let originalWebSocket: WebSocket;
let websocket: WebSocket;

function setup() {
  return new ConnectCommand(mockTMIConnection(), mockTMISession());
}

describe('Command Connect', () => {
  beforeEach(() => {
    originalWebSocket = global.WebSocket as any;
    (global.WebSocket as any) = mockWebSocket();
    websocket = new WebSocket('', '');
  });

  afterEach(() => {
    (global.WebSocket as any) = originalWebSocket;
  });

  it('Correctly resolves beforeSendCommand onopen', async () => {
    const connectCommand = setup();
    const data = { password: '', username: '', ws: websocket };
    const promise = connectCommand.beforeSendCommand(data);
    data.ws.onopen!(new Event('open'));

    await expect(promise).resolves.toBeUndefined();
  });

  it('Correctly generates command text', async () => {
    const connectCommand = setup();
    const data = {
      joinChannel: 'A_Seagull',
      password: 'hunter2',
      username: 'hunter',
      ws: websocket,
    };

    const expectedResult = [
      'CAP REQ :twitch.tv/tags twitch.tv/commands',
      'PASS hunter2',
      'NICK hunter',
      'USER hunter 8 * :hunter',
      'JOIN A_Seagull',
    ];

    const commands = connectCommand.getCommandText(data);
    expect(commands).toEqual(expectedResult);
  });

  it('Correctly generates command text when join is not provided', async () => {
    const connectCommand = setup();
    const data = {
      password: 'hunter2',
      username: 'hunter',
      ws: websocket,
    };

    const expectedResult = [
      'CAP REQ :twitch.tv/tags twitch.tv/commands',
      'PASS hunter2',
      'NICK hunter',
      'USER hunter 8 * :hunter',
    ];

    const commands = connectCommand.getCommandText(data);
    expect(commands).toEqual(expectedResult);
  });
});
