import { TMICommand } from './tmi-command';
import type { TMICommandRequest, TMICommandResponse } from './tmi-command-args';

export interface ConnectCommandRequest extends TMICommandRequest {
  joinChannel?: string | undefined;
  password: string;
  username: string;
  ws: WebSocket;
}

export class ConnectCommand extends TMICommand<
  ConnectCommandRequest,
  TMICommandResponse
> {
  public override async beforeSendCommand(
    data: ConnectCommandRequest,
  ): Promise<void> {
    return new Promise<void>((res) => {
      data.ws.onopen = () => {
        this.logger.debug('Socket opened');
        res();
      };
    });
  }

  public getCommandText(data: ConnectCommandRequest): Array<string> {
    // Authentication..
    const commands = [
      'CAP REQ :twitch.tv/tags twitch.tv/commands',
      `PASS ${data.password}`,
      `NICK ${data.username}`,
      `USER ${data.username} 8 * :${data.username}`,
    ];

    if (data.joinChannel) {
      commands.push(`JOIN ${data.joinChannel}`);
    }

    return commands;
  }
}
