import { TMICommand } from './tmi-command';
import type { TMICommandRequest, TMICommandResponse } from './tmi-command-args';

export interface FollowersOnlyRequest extends TMICommandRequest {
  channel: string;
  minutes?: number;
}

export class FollowersOnlyCommand extends TMICommand<
  FollowersOnlyRequest,
  TMICommandResponse
> {
  public getCommandText(data: FollowersOnlyRequest): Array<string> {
    const mins = data.minutes || 30;
    return [`/followers ${mins}`];
  }
}
