import { TMICommand } from './tmi-command';
import type { TMICommandRequest, TMICommandResponse } from './tmi-command-args';

export interface HostRequest extends TMICommandRequest {
  username: string;
}

export interface HostResponse extends TMICommandResponse {
  remainingHost?: number;
}

export class HostCommand extends TMICommand<HostRequest, HostResponse> {
  public getCommandText(data: HostRequest): Array<string> {
    return [`/host ${data.username}`];
  }
}
