import { Utils } from '../utils';
import { TMICommand } from './tmi-command';
import type { TMICommandRequest, TMICommandResponse } from './tmi-command-args';

export interface TMIJoinRequest extends TMICommandRequest {
  joinChannel: string;
}

export class JoinCommand extends TMICommand<
  TMIJoinRequest,
  TMICommandResponse
> {
  public currentRequest?: TMIJoinRequest;

  public getCommandText(data: TMIJoinRequest): Array<string> {
    data.joinChannel = Utils.channel(data.joinChannel);
    this.currentRequest = data;
    return [`JOIN ${data.joinChannel}`];
  }
}
