import { Utils } from '../utils';
import { TMICommand } from './tmi-command';
import type { TMICommandRequest, TMICommandResponse } from './tmi-command-args';

export interface TMIPartRequest extends TMICommandRequest {
  partChannel: string;
}

export class PartCommand extends TMICommand<
  TMIPartRequest,
  TMICommandResponse
> {
  public getCommandText(data: TMIPartRequest): Array<string> {
    data.partChannel = Utils.channel(data.partChannel);
    return [`PART ${data.partChannel}`];
  }
}
