import { TMICommand } from './tmi-command';
import type { TMICommandRequest, TMICommandResponse } from './tmi-command-args';

export interface SlowModeOnRequest extends TMICommandRequest {
  seconds?: number;
}

export class SlowModeOnCommand extends TMICommand<
  SlowModeOnRequest,
  TMICommandResponse
> {
  public getCommandText(data: SlowModeOnRequest): Array<string> {
    return [`/slow ${data.seconds || 30}`];
  }
}
