import { TMICommand } from './tmi-command';
import type { TMICommandRequest, TMICommandResponse } from './tmi-command-args';

export interface TimeoutRequest extends TMICommandRequest {
  reason: string;
  seconds: number;
  username: string;
}

export class TimeoutCommand extends TMICommand<
  TimeoutRequest,
  TMICommandResponse
> {
  public getCommandText(data: TimeoutRequest): Array<string> {
    return [`/timeout ${data.username} ${data.seconds} ${data.reason}`];
  }
}
