import { TMICommand } from './tmi-command';
import type { TMICommandRequest, TMICommandResponse } from './tmi-command-args';

export interface UnbanRequest extends TMICommandRequest {
  channel: string;
  username: number;
}

export class UnbanCommand extends TMICommand<UnbanRequest, TMICommandResponse> {
  public getCommandText(data: UnbanRequest): Array<string> {
    return [`/unban ${data.username}`];
  }
}
