import { TMICommand } from './tmi-command';
import type { TMICommandRequest, TMICommandResponse } from './tmi-command-args';

export interface WhisperRequest extends TMICommandRequest {
  message: string;
  username: string;
}

export class WhisperCommand extends TMICommand<
  WhisperRequest,
  TMICommandResponse
> {
  public getCommandText(data: WhisperRequest): Array<string> {
    return [`/w ${data.username} ${data.message}`];
  }
}
