import type EventEmitter from 'eventemitter3';
import type { TMIEventName, TMIEvents } from './models';

export class EventProcessors {
  private readonly emitter: EventEmitter<TMIEventName>;
  private isSuppressed: boolean;

  constructor(emitter: EventEmitter<TMIEventName>, isSuppressed: boolean) {
    this.emitter = emitter;
    this.isSuppressed = isSuppressed;
  }

  public unsuppress(): void {
    this.isSuppressed = false;
  }

  public suppress(): void {
    this.isSuppressed = true;
  }

  public action(data: TMIEvents['action']): void {
    this.raise('action', data);
  }

  public disconnected(data: TMIEvents['disconnected']): void {
    this.raise('disconnected', data);
  }

  public connecting(data: TMIEvents['connecting']): void {
    this.raise('connecting', data);
  }

  public connected(data: TMIEvents['connected']): void {
    this.raise('connected', data);
  }

  public reconnecting(data: TMIEvents['reconnecting']): void {
    this.raise('reconnecting', data);
  }

  public reconnected(data: TMIEvents['reconnected']): void {
    this.raise('reconnected', data);
  }

  public chat(data: TMIEvents['chat']): void {
    this.raise('chat', data);
  }

  public firstcheer(data: TMIEvents['firstcheer']): void {
    this.raise('firstcheer', data);
  }

  public anoncheer(data: TMIEvents['anoncheer']): void {
    this.raise('anoncheer', data);
  }

  public joined(data: TMIEvents['joined']): void {
    this.raise('joined', data);
  }

  public parted(data: TMIEvents['parted']): void {
    this.raise('parted', data);
  }

  public followersonly(data: TMIEvents['followersonly']): void {
    this.raise('followersonly', data);
  }

  public badgesupdated(data: TMIEvents['badgesupdated']): void {
    this.raise('badgesupdated', data);
  }

  public clearchat(data: TMIEvents['clearchat']): void {
    this.raise('clearchat', data);
  }

  public clearmsg(data: TMIEvents['clearmsg']): void {
    this.raise('clearmsg', data);
  }

  public hosting(data: TMIEvents['hosting']): void {
    this.raise('hosting', data);
  }

  public hosted(data: TMIEvents['hosted']): void {
    this.raise('hosted', data);
  }

  public ban(data: TMIEvents['ban']): void {
    this.raise('ban', data);
  }

  public timeout(data: TMIEvents['timeout']): void {
    this.raise('timeout', data);
  }

  public emoteonlymode(data: TMIEvents['emoteonlymode']): void {
    this.raise('emoteonlymode', data);
  }

  public mods(data: TMIEvents['mods']): void {
    this.raise('mods', data);
  }

  public names(data: TMIEvents['names']): void {
    this.raise('names', data);
  }

  public notice(data: TMIEvents['notice']): void {
    this.raise('notice', data);
  }

  public usernotice(data: TMIEvents['usernotice']): void {
    this.raise('usernotice', data);
  }

  public purchase(data: TMIEvents['purchase']): void {
    this.raise('purchase', data);
  }

  public crate(data: TMIEvents['crate']): void {
    this.raise('crate', data);
  }

  public rewardgift(data: TMIEvents['rewardgift']): void {
    this.raise('rewardgift', data);
  }

  public raid(data: TMIEvents['raid']): void {
    this.raise('raid', data);
  }

  public ritual(data: TMIEvents['ritual']): void {
    this.raise('ritual', data);
  }

  public r9kmode(data: TMIEvents['r9kmode']): void {
    this.raise('r9kmode', data);
  }

  public resub(data: TMIEvents['resub']): void {
    this.raise('resub', data);
  }

  public extendsub(data: TMIEvents['extendsub']): void {
    this.raise('extendsub', data);
  }

  public giftpaidupgrade(data: TMIEvents['giftpaidupgrade']): void {
    this.raise('giftpaidupgrade', data);
  }

  public anongiftpaidupgrade(data: TMIEvents['anongiftpaidupgrade']): void {
    this.raise('anongiftpaidupgrade', data);
  }

  public primepaidupgrade(data: TMIEvents['primepaidupgrade']): void {
    this.raise('primepaidupgrade', data);
  }

  public primecommunitygiftreceived(
    data: TMIEvents['primecommunitygiftreceived'],
  ): void {
    this.raise('primecommunitygiftreceived', data);
  }

  public roomstate(data: TMIEvents['roomstate']): void {
    this.raise('roomstate', data);
  }

  public slowmode(data: TMIEvents['slowmode']): void {
    this.raise('slowmode', data);
  }

  public subgift(data: TMIEvents['subgift']): void {
    this.raise('subgift', data);
  }

  public anonsubgift(data: TMIEvents['anonsubgift']): void {
    this.raise('anonsubgift', data);
  }

  public submysterygift(data: TMIEvents['submysterygift']): void {
    this.raise('submysterygift', data);
  }

  public anonsubmysterygift(data: TMIEvents['anonsubmysterygift']): void {
    this.raise('anonsubmysterygift', data);
  }

  public communitypayforward(data: TMIEvents['communitypayforward']): void {
    this.raise('communitypayforward', data);
  }

  public standardpayforward(data: TMIEvents['standardpayforward']): void {
    this.raise('standardpayforward', data);
  }

  public subscribers(data: TMIEvents['subscribers']): void {
    this.raise('subscribers', data);
  }

  public charity(data: TMIEvents['charity']): void {
    this.raise('charity', data);
  }

  public subscription(data: TMIEvents['subscription']): void {
    this.raise('subscription', data);
  }

  public unhost(data: TMIEvents['unhost']): void {
    this.raise('unhost', data);
  }

  public unraid(data: TMIEvents['unraid']): void {
    this.raise('unraid', data);
  }

  public mod(data: TMIEvents['mod']): void {
    this.raise('mod', data);
  }

  public unmod(data: TMIEvents['unmod']): void {
    this.raise('unmod', data);
  }

  public whisper(data: TMIEvents['whisper']): void {
    this.raise('whisper', data);
  }

  public bitsbadgetier(data: TMIEvents['bitsbadgetier']): void {
    this.raise('bitsbadgetier', data);
  }

  public contributechannelchallenge(
    data: TMIEvents['contributechannelchallenge'],
  ): void {
    this.raise('contributechannelchallenge', data);
  }

  public channelpointsreward(data: TMIEvents['channelpointsreward']): void {
    this.raise('channelpointsreward', data);
  }

  public celebrationpurchase(data: TMIEvents['celebrationpurchase']): void {
    this.raise('celebrationpurchase', data);
  }

  public useranniversary(data: TMIEvents['useranniversary']): void {
    this.raise('useranniversary', data);
  }

  public timingack(data: TMIEvents['timingack']): void {
    this.raise('timingack', data);
  }

  public communityintroduction(data: TMIEvents['communityintroduction']): void {
    this.raise('communityintroduction', data);
  }

  /**
   * TODO: Make this method public and remove event-specific methods above
   * now that we have type safety on this function.
   */
  private raise<Name extends TMIEventName>(
    name: Name,
    data: TMIEvents[Name],
  ): void {
    if (this.isSuppressed) {
      return;
    }
    this.emitter.emit(name, data);
  }
}
