import { parseFlagsTag } from './flag-parsing';
import { TMIFlagCategory } from './tmi-flag';

describe('parsing AutoMod flags', () => {
  it('parses a single flag', () => {
    const result = parseFlagsTag('0-3:P.6');

    expect(result).toEqual([
      {
        categories: {
          [TMIFlagCategory.Profanity]: true,
        },
        endIndex: 3,
        startIndex: 0,
      },
    ]);
  });

  it('parses multiple flags', () => {
    const result = parseFlagsTag('0-3:P.6,7-10:A.6');

    expect(result).toEqual([
      {
        categories: {
          [TMIFlagCategory.Profanity]: true,
        },
        endIndex: 3,
        startIndex: 0,
      },
      {
        categories: {
          [TMIFlagCategory.Aggressive]: true,
        },
        endIndex: 10,
        startIndex: 7,
      },
    ]);
  });

  it('parses flags with multiple categories', () => {
    const result = parseFlagsTag('0-3:A.6/P.6,7-10:A.6/S.6');

    expect(result).toEqual([
      {
        categories: {
          [TMIFlagCategory.Aggressive]: true,
          [TMIFlagCategory.Profanity]: true,
        },
        endIndex: 3,
        startIndex: 0,
      },
      {
        categories: {
          [TMIFlagCategory.Aggressive]: true,
          [TMIFlagCategory.Sexual]: true,
        },
        endIndex: 10,
        startIndex: 7,
      },
    ]);
  });

  it('ignores flags that have severity 4 or lower', () => {
    const result = parseFlagsTag(
      '0-3:A.0,4-7:A.1,8-11:A.2,12-15:A.3,16-19:A.4,20-23:A.5,24-27:A.4/S.6',
    );

    expect(result).toEqual([
      {
        categories: {
          [TMIFlagCategory.Aggressive]: true,
        },
        endIndex: 23,
        startIndex: 20,
      },
      {
        categories: {
          [TMIFlagCategory.Sexual]: true,
        },
        endIndex: 27,
        startIndex: 24,
      },
    ]);
  });

  it('ignores flags for unknown categories', () => {
    const result = parseFlagsTag('0-3:X.6,4-7:S.6/X.6');

    expect(result).toEqual([
      {
        categories: {
          [TMIFlagCategory.Sexual]: true,
        },
        endIndex: 7,
        startIndex: 4,
      },
    ]);
  });

  it('returns nothing if no matching flag was found', () => {
    const result = parseFlagsTag('0-3:X.6,4-7:S.2');

    expect(result).toBeUndefined();
  });
});
