import { createDefaultRoomState } from '../utils';
import type { TMIRoomState } from './tmi-room-state';
import type { TMIUser } from './tmi-user';

export class TMIChannel {
  public roomState: TMIRoomState;
  public readonly userState: TMIUser;
  public readonly moderators: string[] = [];
  private badgesRaw = '';

  constructor(
    userState: TMIUser,
    roomState: TMIRoomState = createDefaultRoomState(),
  ) {
    this.roomState = roomState;
    this.userState = userState;
  }

  public addModerator(username: string): void {
    if (this.moderators.indexOf(username) < 0) {
      this.moderators.push(username);
    }
  }

  public removeModerator(username: string): void {
    const index = this.moderators.indexOf(username);
    if (index >= 0) {
      this.moderators.splice(index);
    }
  }

  public updateRoomState(nextState: TMIRoomState): void {
    this.roomState = nextState;
  }

  public updateUserState(userState: TMIUser): void {
    if (!userState) {
      return;
    }
    this.userState.color = userState.color;
    this.userState.badges = userState.badges;
    this.userState.bits = userState.bits;
    this.userState.emotes = userState.emotes;
    this.userState.displayName = userState.displayName;
    this.userState.turbo = userState.turbo;
    this.userState.userType = userState.userType;
  }

  public updateBadges(
    badges: Record<string, string>,
    dynamicData: Record<string, string>,
  ): boolean {
    const badgesRaw = JSON.stringify({ badges, dynamicData });
    if (badgesRaw === this.badgesRaw) {
      return false;
    }
    this.userState.badges = badges;
    this.userState.badgeDynamicData = dynamicData;
    this.badgesRaw = badgesRaw;
    return true;
  }
}
