import type { TMIFlag } from './tmi-flag';
import type { TMIUser } from './tmi-user';

export interface Reply {
  parentDeleted: boolean;
  parentDisplayName: string;
  parentMessageBody: string;
  parentMsgId: string;
  parentUid: string;
  parentUserLogin: string;
}

export interface TMIChatMessage {
  bitsImageUrl?: string | undefined;
  body: string;
  flags?: Array<TMIFlag> | undefined;
  id: string;
  // True if the user has chatted for the first time in this channel, parsed from IRC tag first-msg=1
  isFirstMsg?: boolean | undefined;
  nonce?: string | undefined;
  reply?: Reply | undefined;
  timestamp: number;
  user: TMIUser;
}
