import type { TMIAdditionalMetadata } from '../tmi-command-processor';
import type { TMIChatMessage } from './tmi-chat-message';
import type { TMIPurchase } from './tmi-purchase';
import type { TMIRaidEventParams } from './tmi-raid-event-payload';
import type { TMIRitualType } from './tmi-rituals';
import type { TMIRoomState } from './tmi-room-state';
import type { TMIUser } from './tmi-user';

export type TMIEventName = keyof TMIEvents;

export type TMIEventHandler<T extends TMIEventName> = (
  data: TMIEvents[T],
) => void;

// TODO: create sub-types for those that use TMIChatMessageEvent, TMIModerationEvent
export type TMIEvents = {
  action: TMIChatActionEvent;
  anoncheer: TMIChatMessageEvent;
  anongiftpaidupgrade: TMIAnonGiftPaidUpgradeEvent;
  anonsubgift: TMIAnonSubscriptionGiftEvent;
  anonsubmysterygift: TMIAnonSubscriptionMysteryGiftEvent;
  badgesupdated: TMIBadgesUpdatedEvent;
  ban: TMIModerationEvent;
  bitsbadgetier: TMIBitsBadgeTierEvent;
  celebrationpurchase: TMICelebrationPurchaseEvent;
  channelpointsreward: TMIChannelPointsRewardEvent;
  charity: TMIBitsCharityEvent;
  chat: TMIChatMessageEvent;
  cheer: TMIChatMessageEvent;
  clearchat: TMIClearChatEvent;
  clearmsg: TMIClearMsgEvent;
  communityintroduction: TMICommunityIntroductionEvent;
  communitypayforward: TMICommunityPayForwardEvent;
  connected: TMIConnectedEvent;
  connecting: TMIConnectingEvent;
  contributechannelchallenge: TMIContributeChannelChallengeEvent;
  crate: TMICrateEvent;
  disconnected: TMIDisconnectedEvent;
  emoteonlymode: TMIEmoteOnlyModeEvent;
  extendsub: TMIExtendSubscriptionEvent;
  firstcheer: TMIChatMessageEvent;
  followersonly: TMIFollowerOnlyModeEvent;
  giftpaidupgrade: TMIGiftPaidUpgradeEvent;
  hosted: TMIHostedEvent;
  hosting: TMIHostingEvent;
  joined: TMIJoinedEvent;
  mod: TMIModStatusEvent;
  mods: TMIRoomModsEvent;
  names: TMINamesEvent;
  notice: TMIChatNoticeEvent;
  parted: TMIPartedEvent;
  primecommunitygiftreceived: TMIPrimeCommunityGiftReceivedEvent;
  primepaidupgrade: TMIPrimePaidUpgradeEvent;
  purchase: TMIPurchaseEvent;
  r9kmode: TMIR9KModeEvent;
  raid: TMIRaidEvent;
  reconnected: TMIReconnectedEvent;
  reconnecting: TMIReconnectingEvent;
  resub: TMIResubscriptionEvent;
  rewardgift: TMIRewardGiftEvent;
  ritual: TMIRitualEvent;
  roomstate: TMIRoomStateEvent;
  slowmode: TMISlowModeEvent;
  standardpayforward: TMIStandardPayForwardEvent;
  subgift: TMISubscriptionGiftEvent;
  submysterygift: TMISubscriptionMysteryGiftEvent;
  subscribers: TMISubscriberOnlyModeEvent;
  subscription: TMISubscriptionEvent;
  timeout: TMIModerationEvent;
  timingack: TMITimingAckEvent;
  unhost: TMIUnhostEvent;
  unmod: TMIModStatusEvent;
  unraid: TMIUnraidEvent;
  useranniversary: TMIUserAnniversaryEvent;
  usernotice: TMIChatMessageEvent;
  whisper: TMIWhisperEvent;
};

export interface TMIConnectedEvent {
  address: string;
  port: number;
  timestampCreated: number;
  timestampJoined: number;
}

export interface TMIConnectingEvent {
  address: string;
  port: number;
}

export interface TMIDisconnectedEvent {
  reason: string;
}

export interface TMIReconnectingEvent {
  reason: string;
}

export interface TMIReconnectedEvent {
  attempts: number;
  reason: string;
}

export interface TMIJoinedEvent {
  channel: string;
  gotUsername: boolean;
  username: string;
}

export interface TMIPartedEvent {
  channel: string;
  isSelf: boolean;
  username: string;
}

export interface TMIHostingEvent {
  channel: string;
  target: string;
  viewers: number;
}

export interface TMIHostedEvent {
  channel: string;
  from: string;
  isAuto: boolean;
  viewers: number;
}

export interface TMIUnhostEvent {
  channel: string;
  viewers: number;
}

export interface TMIChatMessageEvent {
  additionalMetadata?: TMIAdditionalMetadata | undefined;
  channel: string;
  message: TMIChatMessage;
  sentByCurrentUser: boolean;
  timestamp: number;
  type: TMIChatEventType;
}

export interface TMIChatNoticeEvent {
  body: string;
  channel: string;
  msgid: string;
  timestamp: number;
  type: TMIChatEventType;
}

export interface TMIChatActionEvent {
  action: string;
  channel: string;
  message: TMIChatMessage;
  sentByCurrentUser: boolean;
  timestamp: number;
  type: TMIChatEventType;
}

export interface TMIPurchaseEvent {
  channel: string;
  message: TMIChatMessage;
  purchase: TMIPurchase;
  timestamp: number;
  type: TMIChatEventType;
}

export interface TMICrateEvent {
  channel: string;
  message: TMIChatMessage;
  selectedCount: number;
  timestamp: number;
  type: TMIChatEventType;
}

export interface TMIRewardGiftEvent {
  channel: string;
  domain: string;
  message: TMIChatMessage;
  selectedCount: number;
  timestamp: number;
  totalRewardCount: number;
  triggerAmount: number;
  triggerType: string;
  type: TMIChatEventType;
  user: TMIUser;
}

export enum TMIChatEventType {
  Message,
  Notice,
  Action,
  Purchase,
  UserNotice,
  Crate,
  RewardGift,
  FirstCheer,
  AnonCheer,
  BitsBadgeTier,
  ContributeChannelChallenge,
}

export interface TMIWhisperEvent {
  body: string;
  sender: TMIUser;
  sentByCurrentUser: boolean;
}

export interface TMIModerationEvent {
  channel: string;
  duration: number | null;
  reason: string | null;
  userLogin: string;
}

export interface TMISubscriptionEvent {
  channel: string;
  goalData?: TMISubscriptionGoalData | undefined;
  methods: TMISubscriptionMethods;
  multiMonthData?: TMIResubscriptionMultiMonthData | undefined;
  user: TMIUser;
}

export interface TMIResubscriptionGifterData {
  anonGift: boolean;
  giftMonthBeingRedeemed: number;
  giftedMonths: number;
  gifterId: string;
  gifterLogin: string;
  gifterName: string;
}

export interface TMIResubscriptionMultiMonthData {
  multiMonthDuration: number;
  multiMonthTenure: number;
}

export interface TMISubscriptionGoalData {
  contributionType: string;
  currentContributions: number;
  description?: string;
  targetContributions: number;
  userContributions: number;
}

export type TMISubscriptionFunFact =
  | {
      followingAge: number;
      funFactType: 'following-age';
    }
  | {
      funFactType: 'emote-usage';
      mostUsedEmoteID: string;
    };

export interface TMIResubscriptionEvent {
  body: string;
  channel: string;
  cumulativeMonths: number;
  funFact?: TMISubscriptionFunFact | undefined;
  giftData?: TMIResubscriptionGifterData | undefined;
  goalData?: TMISubscriptionGoalData | undefined;
  methods: TMISubscriptionMethods;
  months: number;
  multiMonthData?: TMIResubscriptionMultiMonthData | undefined;
  shouldShareStreakTenure: boolean;
  streakMonths?: number | undefined;
  user: TMIUser;
  wasGifted: boolean;
}

export interface TMIExtendSubscriptionEvent {
  benefitEndMonth: string;
  body: string;
  channel: string;
  goalData?: TMISubscriptionGoalData | undefined;
  tier: string;
  user: TMIUser;
}

export interface TMIGiftPaidUpgradeEvent {
  channel: string;
  goalData?: TMISubscriptionGoalData | undefined;
  promoGiftTotal?: number;
  promoName?: string;
  senderLogin: string;
  senderName: string;
  user: TMIUser;
}

export interface TMIAnonGiftPaidUpgradeEvent {
  channel: string;
  goalData?: TMISubscriptionGoalData | undefined;
  promoGiftTotal?: number;
  promoName?: string;
  user: TMIUser;
}

export interface TMIPrimePaidUpgradeEvent {
  channel: string;
  goalData?: TMISubscriptionGoalData | undefined;
  plan: string;
  user: TMIUser;
}

export interface TMIPrimeCommunityGiftReceivedEvent {
  channel: string;
  channelName: string;
  giftName: string;
  receiver: string;
  sender: string;
  user: TMIUser;
}

export interface TMIBitsCharityEvent {
  channel: string;
  charityName: string;
  daysLeft: number;
  hashtag: string;
  hoursLeft: number;
  learnMore: string;
  total: number;
}

export interface TMISubscriptionGiftEvent {
  channel: string;
  giftMonths: number;
  giftTheme: string;
  goalData?: TMISubscriptionGoalData | undefined;
  methods: TMISubscriptionMethods;
  recipientID: string;
  recipientLogin: string;
  recipientName: string;
  senderCount: number;
  user: TMIUser;
}

export interface TMIAnonSubscriptionGiftEvent {
  channel: string;
  funString: string;
  giftMonths: number;
  goalData?: TMISubscriptionGoalData | undefined;
  methods: TMISubscriptionMethods;
  recipientID: string;
  recipientLogin: string;
  recipientName: string;
}

export interface TMISubscriptionMysteryGiftEvent {
  channel: string;
  giftTheme: string;
  goalData?: TMISubscriptionGoalData | undefined;
  massGiftCount: number;
  plan: string;
  senderCount: number;
  user: TMIUser;
}

export interface TMIAnonSubscriptionMysteryGiftEvent {
  channel: string;
  funString: string;
  goalData?: TMISubscriptionGoalData | undefined;
  massGiftCount: number;
  plan: string;
}

export interface TMISubscriptionMethods {
  plan: string;
  planName: string;
  prime: boolean;
}

export interface TMIRoomStateEvent {
  channel: string;
  state: TMIRoomState;
}

export interface TMIRoomModsEvent {
  channel: string;
  usernames: string[];
}

export interface TMISlowModeEvent {
  channel: string;
  enabled: boolean;
  length: number;
}

export interface TMIEmoteOnlyModeEvent {
  channel: string;
  enabled: boolean;
}

export interface TMIR9KModeEvent {
  channel: string;
  enabled: boolean;
}

export interface TMIFollowerOnlyModeEvent {
  channel: string;
  enabled: boolean;
  length: number;
}

export interface TMISubscriberOnlyModeEvent {
  channel: string;
  enabled: boolean;
}

export interface TMIClearChatEvent {
  channel: string;
}

export interface TMIClearMsgEvent {
  body: string;
  channel: string;
  targetMessageID: string;
  userLogin: string;
}

export interface TMIRaidEvent {
  channel: string;
  params: TMIRaidEventParams;
  userLogin: string;
}

export interface TMIUnraidEvent {
  channel: string;
  message: string;
  userLogin: string;
}

export interface TMIRitualEvent {
  channel: string;
  message: TMIChatMessage;
  type: TMIRitualType;
}

export interface TMIBadgesUpdatedEvent {
  badgeDynamicData?: Record<string, string> | undefined;
  badges: Record<string, string>;
  username: string;
}

export interface TMIModStatusEvent {
  channel: string;
  username: string;
}

export interface TMINamesEvent {
  channel: string;
  names: string[];
}

export interface TMIBitsBadgeTierEvent {
  channel: string;
  message: TMIChatMessage;
  sentByCurrentUser: boolean;
  threshold: number;
  timestamp: number;
  type: TMIChatEventType;
}

export interface TMIContributeChannelChallengeEvent {
  bits: number;
  channel: string;
  message: TMIChatMessage;
  sentByCurrentUser: boolean;
  timestamp: number;
  title: string;
  type: TMIChatEventType;
  userID: string;
}

export interface TMIChannelPointsRewardEvent {
  channel: string;
  message: TMIChatMessage;
  rewardID: string;
}

export interface TMICommunityPayForwardEvent {
  channel: string;
  priorGifterAnonymous: boolean;
  priorGifterID: string;
  priorGifterName: string;
  user: TMIUser;
}

export interface TMIStandardPayForwardEvent {
  channel: string;
  priorGifterAnonymous: boolean;
  priorGifterID: string;
  priorGifterName: string;
  recipientID: string;
  recipientName: string;
  user: TMIUser;
}

export interface TMITimingAckEvent {
  channel: string;
  nonce: string;
}

export interface TMICelebrationPurchaseEvent {
  channel: string;
  effect: string;
  intensity: string;
  user: TMIUser;
}

export interface TMIUserAnniversaryEvent {
  channel: string;
  message: TMIChatMessage;
  years: number;
}

export interface TMICommunityIntroductionEvent {
  channel: string;
  message: TMIChatMessage;
}
