import type { TMIEmotePositionMap } from './tmi-emote-data';

/**
 * This interface represents the extra information
 * that is part of a new message that comes through TMI.
 */
export interface TMIUser {
  badgeDynamicData: Record<string, string> | null;
  badges: Record<string, string> | null;
  bits: number;
  color: string;
  displayName: string;
  emotes: TMIEmotePositionMap;
  id: string;
  turbo: boolean;
  userID: string;
  userType: string;
  username: string;
}
