import type { EventProcessors } from '../../event-processors';

/**
 * Returns a mocked EventProcessors class.
 */
export function mockEventProcessors(): EventProcessors {
  // Assign to an intermediate type for type safety before casting to any
  // to avoid having to mock private class details
  const mockProcessors: Omit<EventProcessors, 'emitter'> = {
    action: jest.fn(),
    anoncheer: jest.fn(),
    anongiftpaidupgrade: jest.fn(),
    anonsubgift: jest.fn(),
    anonsubmysterygift: jest.fn(),
    badgesupdated: jest.fn(),
    ban: jest.fn(),
    bitsbadgetier: jest.fn(),
    celebrationpurchase: jest.fn(),
    channelpointsreward: jest.fn(),
    charity: jest.fn(),
    chat: jest.fn(),
    clearchat: jest.fn(),
    clearmsg: jest.fn(),
    communityintroduction: jest.fn(),
    communitypayforward: jest.fn(),
    connected: jest.fn(),
    connecting: jest.fn(),
    contributechannelchallenge: jest.fn(),
    crate: jest.fn(),
    disconnected: jest.fn(),
    emoteonlymode: jest.fn(),
    extendsub: jest.fn(),
    firstcheer: jest.fn(),
    followersonly: jest.fn(),
    giftpaidupgrade: jest.fn(),
    hosted: jest.fn(),
    hosting: jest.fn(),
    joined: jest.fn(),
    mod: jest.fn(),
    mods: jest.fn(),
    names: jest.fn(),
    notice: jest.fn(),
    parted: jest.fn(),
    primecommunitygiftreceived: jest.fn(),
    primepaidupgrade: jest.fn(),
    purchase: jest.fn(),
    r9kmode: jest.fn(),
    raid: jest.fn(),
    reconnected: jest.fn(),
    reconnecting: jest.fn(),
    resub: jest.fn(),
    rewardgift: jest.fn(),
    ritual: jest.fn(),
    roomstate: jest.fn(),
    slowmode: jest.fn(),
    standardpayforward: jest.fn(),
    subgift: jest.fn(),
    submysterygift: jest.fn(),
    subscribers: jest.fn(),
    subscription: jest.fn(),
    suppress: jest.fn(),
    timeout: jest.fn(),
    timingack: jest.fn(),
    unhost: jest.fn(),
    unmod: jest.fn(),
    unraid: jest.fn(),
    unsuppress: jest.fn(),
    useranniversary: jest.fn(),
    usernotice: jest.fn(),
    whisper: jest.fn(),
  };

  return mockProcessors as any;
}
