import type { TMICommands } from '../../tmi-commands';
import { mockTMICommand } from './tmi-command';

/**
 * Returns a mocked TMICommands class.
 */
export function mockTMICommands(): TMICommands {
  return {
    ban: mockTMICommand(),
    clearChat: mockTMICommand(),
    color: mockTMICommand(),
    commercial: mockTMICommand(),
    connect: mockTMICommand(),
    emoteOnlyModeOff: mockTMICommand(),
    emoteOnlyModeOn: mockTMICommand(),
    failAll: jest.fn(),
    followersOnlyOff: mockTMICommand(),
    followersOnlyOn: mockTMICommand(),
    host: mockTMICommand(),
    join: mockTMICommand(),
    part: mockTMICommand(),
    ping: mockTMICommand(),
    processCommand: jest.fn(),
    rk9ModeOff: mockTMICommand(),
    rk9ModeOn: mockTMICommand(),
    sendMessage: mockTMICommand(),
    slowModeOff: mockTMICommand(),
    slowModeOn: mockTMICommand(),
    subscriberModeOff: mockTMICommand(),
    subscriberModeOn: mockTMICommand(),
    timeout: mockTMICommand(),
    unban: mockTMICommand(),
    unhost: mockTMICommand(),
    whisper: mockTMICommand(),
  } as any;
}
