import type { TMIEmoteMap } from '../../models';

/* eslint-disable sort-keys-fix/sort-keys-fix */
export function mockTMIEmoteMap(): TMIEmoteMap {
  return {
    Kappa: {
      id: '25',
      token: 'Kappa',
    },
    'B-?\\)': {
      id: '0',
      token: 'B-?\\)',
    },
    ':-?[z|Z|\\|]': {
      id: '1',
      token: ':-?[z|Z|\\|]',
    },
    ':-?\\)': {
      id: '2',
      token: ':-?\\)',
    },
    ':-?\\(': {
      id: '3',
      token: ':-?\\(',
    },
    ':-?(p|P)': {
      id: '4',
      token: ':-?(p|P)',
    },
    ';-?(p|P)': {
      id: '5',
      token: ';-?(p|P)',
    },
    ':-?[\\\\/]': {
      id: '6',
      token: ':-?[\\\\/]',
    },
    ';-?\\)': {
      id: '7',
      token: ';-?\\)',
    },
    'R-?\\)': {
      id: '8',
      token: 'R-?\\)',
    },
    ':>': {
      id: '9',
      token: ':>',
    },
    '[oO](_|\\.)[oO]': {
      id: '10',
      token: '[oO](_|\\.)[oO]',
    },
    ':-?D': {
      id: '11',
      token: ':-?D',
    },
    ':-?(o|O)': {
      id: '12',
      token: ':-?(o|O)',
    },
    '>\\(': {
      id: '13',
      token: '>\\(',
    },
    ':-?(?:7|L)': {
      id: '14',
      token: ':-?(?:7|L)',
    },
    ':-?(S|s)': {
      id: '15',
      token: ':-?(S|s)',
    },
    '#-?[\\\\/]': {
      id: '16',
      token: '#-?[\\\\/]',
    },
    '<\\]': {
      id: '17',
      token: '<\\]',
    },
    '<3': {
      id: '18',
      token: '<3',
    },
    '&lt;3': {
      id: '19',
      token: '&lt;3',
    },
    '&lt;\\]': {
      id: '20',
      token: '&lt;\\]',
    },
    '&gt;\\(': {
      id: '21',
      token: '&gt;\\(',
    },
  };
}
