import type { TMILogger } from '../../models';

/* eslint-disable no-console */

export function mockTMILogger(shouldLog = false): TMILogger {
  const logger: TMILogger = {
    debug: jest.fn(),
    error: jest.fn(),
    info: jest.fn(),
    trackAndWarn: jest.fn(),
    warn: jest.fn(),
  };

  if (shouldLog) {
    (logger.debug as any).mockImplementation((message: string) =>
      console.log(message),
    );
    (logger.info as any).mockImplementation((message: string) =>
      console.log(message),
    );
    (logger.warn as any).mockImplementation((message: string) =>
      console.log(message),
    );
    (logger.error as any).mockImplementation((error: Error, message: string) =>
      console.log(error, message),
    );
    (logger.trackAndWarn as any).mockImplementation(
      (
        spadeEventString: string,
        params: Record<string, unknown>,
        message: string,
      ) => console.log(spadeEventString, params, message),
    );
  }

  return logger;
}
