import type { TMIParser } from '../../tmi-parser';

export const VALID_TMI_MESSAGE =
  '@withoutValueDefaultsToTrue;badges=staff/1,twitchcon2017/1;color=#FF0000;display-name=sender;emotes=425618:0-2,7-9;id=65cec081-1b20-4838-aa59-843cee27d780;mod=0;room-id=56789;subscriber=0;tmi-sent-ts=1532994923620;turbo=0;user-id=123456;user-type=staff :sender!sender@sender.tmi.twitch.tv PRIVMSG #testchannel :LUL hi LUL';

export const PARSED_VALID_TMI_MESSAGE = {
  command: 'PRIVMSG',
  params: ['#testchannel', 'LUL hi LUL'],
  prefix: 'sender!sender@sender.tmi.twitch.tv',
  raw: VALID_TMI_MESSAGE,
  tags: {
    badges: 'staff/1,twitchcon2017/1',
    color: '#FF0000',
    'display-name': 'sender',
    emotes: '425618:0-2,7-9',
    id: '65cec081-1b20-4838-aa59-843cee27d780',
    mod: '0',
    'room-id': '56789',
    subscriber: '0',
    'tmi-sent-ts': '1532994923620',
    turbo: '0',
    'user-id': '123456',
    'user-type': 'staff',
    withoutValueDefaultsToTrue: 'true',
  },
};

export const TMI_MESSAGE_MULTIPLE_EQUALS_TAG =
  '@reply-parent-msg-body=test=best;reply-parent-msg-id=4110eb10-f5f2-42e8-b1bd-ef991cb42e50 :sender!sender@sender.tmi.twitch.tv PRIVMSG #test_channel :@user Test reply';

export const PARSED_TMI_MESSAGE_MULTIPLE_EQUALS_TAG = {
  command: 'PRIVMSG',
  params: ['#test_channel', '@user Test reply'],
  prefix: 'sender!sender@sender.tmi.twitch.tv',
  raw: TMI_MESSAGE_MULTIPLE_EQUALS_TAG,
  tags: {
    'reply-parent-msg-body': 'test=best',
    'reply-parent-msg-id': '4110eb10-f5f2-42e8-b1bd-ef991cb42e50',
  },
};

export function mockTMIParser(): TMIParser {
  return {
    badges: jest.fn(),
    emotes: jest.fn(),
    msg: jest.fn(),
  } as any;
}
