enum WebSocketReadyState {
  CLOSED,
  OPEN,
}

export function mockWebSocket(): any {
  return class MockWebSocket {
    public static instances: MockWebSocket[] = [];
    public static CLOSED = WebSocketReadyState.CLOSED;
    public static OPEN = WebSocketReadyState.OPEN;
    public url: string;
    public send = jest.fn();
    public close = jest.fn();
    public readyState: number = WebSocketReadyState.OPEN;

    constructor(url: string) {
      this.url = url;
      MockWebSocket.instances.push(this);
    }

    public setReadyState(readyState: WebSocketReadyState) {
      this.readyState = readyState;
    }
  };
}
