import type EventEmitter from 'eventemitter3';
import type {
  TMIChatActionEvent,
  TMIEventHandler,
  TMIEventName,
  TMILogger,
} from './models';

// TODO(mikeche): We should consider where in the chain we want to be splitting logic by message
// type. Right now, each type must be hooked up separately by the consumer, resulting in a lot of
// boilerplate code.
export class TMIEventHandlers {
  private readonly emitter: EventEmitter<TMIEventName>;
  private readonly logger: TMILogger;

  constructor(emitter: EventEmitter<TMIEventName>, logger: TMILogger) {
    this.emitter = emitter;
    this.logger = logger;
  }

  public action(handler: (data: TMIChatActionEvent) => void): void {
    this.add('action', handler);
  }

  public badgesupdated(handler: TMIEventHandler<'badgesupdated'>): void {
    this.add('badgesupdated', handler);
  }

  public ban(handler: TMIEventHandler<'ban'>): void {
    this.add('ban', handler);
  }

  public bitsbadgetier(handler: TMIEventHandler<'bitsbadgetier'>): void {
    this.add('bitsbadgetier', handler);
  }

  public channelpointsreward(
    handler: TMIEventHandler<'channelpointsreward'>,
  ): void {
    this.add('channelpointsreward', handler);
  }

  public charity(handler: TMIEventHandler<'charity'>): void {
    this.add('charity', handler);
  }

  public chat(handler: TMIEventHandler<'chat'>): void {
    this.add('chat', handler);
  }

  public clearchat(handler: TMIEventHandler<'clearchat'>): void {
    this.add('clearchat', handler);
  }

  public clearmsg(handler: TMIEventHandler<'clearmsg'>): void {
    this.add('clearmsg', handler);
  }

  public crate(handler: TMIEventHandler<'crate'>): void {
    this.add('crate', handler);
  }

  public connected(handler: TMIEventHandler<'connected'>): void {
    this.add('connected', handler);
  }

  public contributechannelchallenge(
    handler: TMIEventHandler<'contributechannelchallenge'>,
  ): void {
    this.add('contributechannelchallenge', handler);
  }

  public connecting(handler: TMIEventHandler<'connecting'>): void {
    this.add('connecting', handler);
  }

  public communityintroduction(
    handler: TMIEventHandler<'communityintroduction'>,
  ): void {
    this.add('communityintroduction', handler);
  }

  public disconnected(handler: TMIEventHandler<'disconnected'>): void {
    this.add('disconnected', handler);
  }

  public emoteonlymode(callback: TMIEventHandler<'emoteonlymode'>): void {
    this.add('emoteonlymode', callback);
  }

  public firstcheer(handler: TMIEventHandler<'firstcheer'>): void {
    this.add('firstcheer', handler);
  }

  public anoncheer(handler: TMIEventHandler<'anoncheer'>): void {
    this.add('anoncheer', handler);
  }

  public followersonly(handler: TMIEventHandler<'followersonly'>): void {
    this.add('followersonly', handler);
  }

  public hosted(handler: TMIEventHandler<'hosted'>): void {
    this.add('hosted', handler);
  }

  public hosting(handler: TMIEventHandler<'hosting'>): void {
    this.add('hosting', handler);
  }

  public joined(handler: TMIEventHandler<'joined'>): void {
    this.add('joined', handler);
  }

  public mods(handler: TMIEventHandler<'mods'>): void {
    this.add('mods', handler);
  }

  public notice(handler: TMIEventHandler<'notice'>): void {
    this.add('notice', handler);
  }

  public parted(handler: TMIEventHandler<'parted'>): void {
    this.add('parted', handler);
  }

  public primecommunitygiftreceived(
    handler: TMIEventHandler<'primecommunitygiftreceived'>,
  ): void {
    this.add('primecommunitygiftreceived', handler);
  }

  public purchase(handler: TMIEventHandler<'purchase'>): void {
    this.add('purchase', handler);
  }

  public r9kmode(callback: TMIEventHandler<'r9kmode'>): void {
    this.add('r9kmode', callback);
  }

  public raid(handler: TMIEventHandler<'raid'>): void {
    this.add('raid', handler);
  }

  public reconnected(handler: TMIEventHandler<'reconnected'>): void {
    this.add('reconnected', handler);
  }

  public reconnecting(handler: TMIEventHandler<'reconnecting'>): void {
    this.add('reconnecting', handler);
  }

  public resub(handler: TMIEventHandler<'resub'>): void {
    this.add('resub', handler);
  }

  public extendsub(handler: TMIEventHandler<'extendsub'>): void {
    this.add('extendsub', handler);
  }

  public giftpaidupgrade(handler: TMIEventHandler<'giftpaidupgrade'>): void {
    this.add('giftpaidupgrade', handler);
  }

  public anongiftpaidupgrade(
    handler: TMIEventHandler<'anongiftpaidupgrade'>,
  ): void {
    this.add('anongiftpaidupgrade', handler);
  }

  public primepaidupgrade(handler: TMIEventHandler<'primepaidupgrade'>): void {
    this.add('primepaidupgrade', handler);
  }

  public rewardgift(handler: TMIEventHandler<'rewardgift'>): void {
    this.add('rewardgift', handler);
  }

  public ritual(handler: TMIEventHandler<'ritual'>): void {
    this.add('ritual', handler);
  }

  public roomstate(handler: TMIEventHandler<'roomstate'>): void {
    this.add('roomstate', handler);
  }

  public slowmode(handler: TMIEventHandler<'slowmode'>): void {
    this.add('slowmode', handler);
  }

  public subgift(handler: TMIEventHandler<'subgift'>): void {
    this.add('subgift', handler);
  }

  public anonsubgift(handler: TMIEventHandler<'anonsubgift'>): void {
    this.add('anonsubgift', handler);
  }

  public submysterygift(handler: TMIEventHandler<'submysterygift'>): void {
    this.add('submysterygift', handler);
  }

  public anonsubmysterygift(
    handler: TMIEventHandler<'anonsubmysterygift'>,
  ): void {
    this.add('anonsubmysterygift', handler);
  }

  public communitypayforward(
    handler: TMIEventHandler<'communitypayforward'>,
  ): void {
    this.add('communitypayforward', handler);
  }

  public standardpayforward(
    handler: TMIEventHandler<'standardpayforward'>,
  ): void {
    this.add('standardpayforward', handler);
  }

  public subscribers(handler: TMIEventHandler<'subscribers'>): void {
    this.add('subscribers', handler);
  }

  public subscription(handler: TMIEventHandler<'subscription'>): void {
    this.add('subscription', handler);
  }

  public timeout(handler: TMIEventHandler<'timeout'>): void {
    this.add('timeout', handler);
  }

  public timingack(handler: TMIEventHandler<'timingack'>): void {
    this.add('timingack', handler);
  }

  public unhost(handler: TMIEventHandler<'unhost'>): void {
    this.add('unhost', handler);
  }

  public unraid(handler: TMIEventHandler<'unraid'>): void {
    this.add('unraid', handler);
  }

  public useranniversary(handler: TMIEventHandler<'useranniversary'>): void {
    this.add('useranniversary', handler);
  }

  public usernotice(handler: TMIEventHandler<'usernotice'>): void {
    this.add('usernotice', handler);
  }

  public celebrationpurchase(
    handler: TMIEventHandler<'celebrationpurchase'>,
  ): void {
    this.add('celebrationpurchase', handler);
  }

  public remove<Name extends TMIEventName>(
    name: Name,
    callback: TMIEventHandler<Name>,
  ): void {
    this.emitter.removeListener(name, callback);
  }

  public removeAll(): void {
    this.logger.debug('Removed all event listeners');
    this.emitter.removeAllListeners();
  }

  /**
   * TODO: Make this method public and remove event-specific methods above
   * now that we have type safety on this function.
   */
  private add<Name extends TMIEventName>(
    name: Name,
    callback: TMIEventHandler<Name>,
  ): void {
    this.emitter.addListener(name, callback);
  }
}
