import { createEmoteMap } from './emote-map';

describe('creating the emote set', () => {
  it('creates unescaped entries for HTML entities', () => {
    const map = createEmoteMap([
      {
        emotes: [
          {
            id: '1',
            token: '\\:\\&gt\\;',
          },
          {
            id: '2',
            token: '\\&gt\\;\\(',
          },
          {
            id: '3',
            token: '\\&lt\\;\\]',
          },
          {
            id: '4',
            token: '\\&lt\\;3',
          },
        ],
        id: 'mocked-set-id',
      },
    ]);

    expect(map[':>']).toBeTruthy();
    expect(map['>(']).toBeTruthy();
    expect(map['<]']).toBeTruthy();
    expect(map['<3']).toBeTruthy();
  });

  it('creates multiple entries for regular expressions', () => {
    const map = createEmoteMap([
      {
        emotes: [
          {
            id: 'mocked-emote-id',
            token: '\\:-?[z|Z|\\|]',
          },
        ],
        id: 'mocked-set-id',
      },
    ]);

    expect(map[':-|'].id).toBe('mocked-emote-id');
    expect(map[':|'].id).toBe('mocked-emote-id');
    expect(map[':-Z'].id).toBe('mocked-emote-id');
    expect(map[':Z'].id).toBe('mocked-emote-id');
    expect(map[':-z'].id).toBe('mocked-emote-id');
    expect(map[':z'].id).toBe('mocked-emote-id');
  });
});
