import type { TMIEmotePositionMap } from '../models';
import { mockTMIEmoteMap } from '../tests';
import { generateEmotePositions } from './emote-parsing';

describe('generating emote positions', () => {
  it('considers emojis single characters', () => {
    const message = '🐶 hello Kappa';
    const emoteMap = mockTMIEmoteMap();
    const emotes: TMIEmotePositionMap = generateEmotePositions(
      message,
      emoteMap,
    );
    const startIndex = 8;

    expect(Object.keys(emotes)).toHaveLength(1);
    expect(emotes[startIndex]).toBeDefined();
    expect(emotes[startIndex]).toEqual({ id: '25', startIndex });
  });

  it('handles multiple sequential delimiters', () => {
    const message = 'Kappa  Kappa';
    const emoteMap = mockTMIEmoteMap();
    const emotes: TMIEmotePositionMap = generateEmotePositions(
      message,
      emoteMap,
    );
    const startIndex1 = 0;
    const startIndex2 = 7;

    expect(Object.keys(emotes)).toHaveLength(2);
    expect(emotes[startIndex1]).toBeDefined();
    expect(emotes[startIndex1]).toEqual({ id: '25', startIndex: startIndex1 });
    expect(emotes[startIndex2]).toBeDefined();
    expect(emotes[startIndex2]).toEqual({ id: '25', startIndex: startIndex2 });
  });

  it('handles non-whitespace delimiters', () => {
    const message = 'Kappa.test Kappa,test Kappa!test';
    const emoteMap = mockTMIEmoteMap();
    const emotes: TMIEmotePositionMap = generateEmotePositions(
      message,
      emoteMap,
    );
    const startIndex1 = 0;
    const startIndex2 = 11;
    const startIndex3 = 22;

    expect(Object.keys(emotes)).toHaveLength(3);
    expect(emotes[startIndex1]).toBeDefined();
    expect(emotes[startIndex1]).toEqual({ id: '25', startIndex: startIndex1 });
    expect(emotes[startIndex2]).toBeDefined();
    expect(emotes[startIndex2]).toEqual({ id: '25', startIndex: startIndex2 });
    expect(emotes[startIndex3]).toBeDefined();
    expect(emotes[startIndex3]).toEqual({ id: '25', startIndex: startIndex3 });
  });
});
