import { parseReplyTags } from './reply-parsing';

describe('reply', () => {
  it('does nothing if there is no reply.', () => {
    const result = parseReplyTags({});
    expect(result).toBeUndefined();
  });

  it('adds a reply object to the message object.', () => {
    const result = parseReplyTags({
      'reply-parent-display-name': 'supsup',
      'reply-parent-msg-body': 'hello there',
      'reply-parent-msg-id': '1234',
      'reply-parent-user-id': '234-fjew-3jkf',
      'reply-parent-user-login': 'itsme',
    });
    const expectedReply = {
      parentDeleted: false,
      parentDisplayName: 'supsup',
      parentMessageBody: 'hello there',
      parentMsgId: '1234',
      parentUid: '234-fjew-3jkf',
      parentUserLogin: 'itsme',
    };
    expect(result).toEqual(expectedReply);
  });
});
