import type { Reply, TMIMessageTags } from '../models';
import { Utils } from './utils';

export function parseReplyTags(tags: TMIMessageTags): Reply | undefined {
  if (
    !tags['reply-parent-msg-id'] ||
    !tags['reply-parent-display-name'] ||
    !tags['reply-parent-user-id'] ||
    !tags['reply-parent-user-login'] ||
    !tags['reply-parent-msg-body']
  ) {
    return;
  }

  return {
    parentDeleted: false,
    parentDisplayName: Utils.decodeTag(tags['reply-parent-display-name']),
    parentMessageBody: Utils.decodeTag(tags['reply-parent-msg-body']),
    parentMsgId: Utils.decodeTag(tags['reply-parent-msg-id']),
    parentUid: Utils.decodeTag(tags['reply-parent-user-id']),
    parentUserLogin: Utils.decodeTag(tags['reply-parent-user-login']),
  };
}
