import type { BranchError, DeepLinkData, DeepViewOptions } from 'branch-sdk';
import type { FC } from 'react';
import { useEffect } from 'react';
import { useDeepview } from '../useDeepview';

export type DeepviewProps = {
  data: DeepLinkData;
  onError?: (err: BranchError) => void;
  options?: DeepViewOptions;
};

/**
 * A declarative version of `useDeepview()`.
 *
 * @param {DeepLinkData} data The data for your {@link https://help.branch.io/developers-hub/docs/web-full-reference#section-deepview-data-options-callback deepview}.
 * @param {DeepViewOptions} options The deepview options.
 * @param {boolean} options.make_new_link whether to create a new link even if one already exists. `default: false`
 * @param {boolean} options.open_app whether to try to open the app passively (as opposed to opening it upon user clicking). `default: true`
 * @param {function} onError optional onError callback
 */
export const Deepview: FC<DeepviewProps> = ({ data, onError, options }) => {
  const [error] = useDeepview(data, options);
  useEffect(() => {
    if (error && onError) {
      onError(error);
    }
  }, [onError, error]);
  return null;
};
