import branchSDK from 'branch-sdk';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { generateDeepLinkData, generateDeepViewOptions } from '../test-utils';
import { Deepview } from '.';

jest.mock('branch-sdk');

describe(Deepview, () => {
  afterEach(() => {
    jest.resetAllMocks();
  });

  const setup = createMountWrapperFactory(Deepview, () => ({
    data: generateDeepLinkData(),
    onError: jest.fn(),
  }));

  describe('success cases', () => {
    it('calls  branch.deepview() with the expected deepview data', () => {
      const { props, wrapper } = setup();
      expect(wrapper.html()).toBeNull();
      expect(branchSDK.deepview).toHaveBeenCalledTimes(1);
      expect(branchSDK.deepview).toHaveBeenCalledWith(
        props.data,
        props.options,
        expect.any(Function),
      );
    });

    it('calls  branch.deepview() with the expected deepview data & option data', () => {
      const { props, wrapper } = setup({ options: generateDeepViewOptions() });
      expect(wrapper.html()).toBeNull();
      expect(branchSDK.deepview).toHaveBeenCalledTimes(1);
      expect(branchSDK.deepview).toHaveBeenCalledWith(
        props.data,
        props.options,
        expect.any(Function),
      );
    });
  });

  describe('error cases', () => {
    const errorMessage = 'error';
    const failureMockImplementation = (_: any, __: any, cb: any) =>
      cb(errorMessage, null);

    it('calls  branch.deepview() with the expected deepview data', () => {
      (
        branchSDK.deepview as jest.MockedFunction<typeof branchSDK.deepview>
      ).mockImplementation(failureMockImplementation);
      const { props, wrapper } = setup();
      expect(wrapper.html()).toBeNull();
      expect(branchSDK.deepview).toHaveBeenCalledTimes(1);
      expect(branchSDK.deepview).toHaveBeenCalledWith(
        props.data,
        props.options,
        expect.any(Function),
      );
      expect(wrapper.props().onError).toHaveBeenCalledTimes(1);
      expect(wrapper.props().onError).toHaveBeenCalledWith(errorMessage);
    });

    it('calls  branch.deepview() with the expected deepview data & option data', () => {
      (
        branchSDK.deepview as jest.MockedFunction<typeof branchSDK.deepview>
      ).mockImplementation(failureMockImplementation);
      const { props, wrapper } = setup({ options: generateDeepViewOptions() });
      expect(wrapper.html()).toBeNull();
      expect(branchSDK.deepview).toHaveBeenCalledTimes(1);
      expect(branchSDK.deepview).toHaveBeenCalledWith(
        props.data,
        props.options,
        expect.any(Function),
      );
      expect(wrapper.props().onError).toHaveBeenCalledTimes(1);
      expect(wrapper.props().onError).toHaveBeenCalledWith(errorMessage);
    });
  });
});
