import type { DeepLinkData } from 'branch-sdk';
import type { FC } from 'react';
import { useJourneyViewData } from '../useJourneyViewData';

export type JourneyViewDataProps = {
  data: DeepLinkData;
};

/**
 * A declarative version of `useJourneyViewData()`.
 *
 * @param {DeepLinkData} data Deeplink data for your journeys.
 */
export const JourneyViewData: FC<JourneyViewDataProps> = ({ data }) => {
  useJourneyViewData(data);
  return null;
};
