import branchSDK from 'branch-sdk';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { generateDeepLinkData } from '../test-utils';
import { JourneyViewData } from '.';

jest.mock('branch-sdk');

describe(JourneyViewData, () => {
  afterEach(() => {
    jest.resetAllMocks();
  });

  const deepview_data = generateDeepLinkData();
  const setup = createMountWrapperFactory(JourneyViewData, () => ({
    data: deepview_data,
  }));

  it('calls branch.setBranchViewData() with the expected deepview data', () => {
    const { wrapper } = setup();

    expect(wrapper.html()).toBeNull();
    expect(branchSDK.setBranchViewData).toHaveBeenCalledTimes(1);
    expect(branchSDK.setBranchViewData).toHaveBeenCalledWith(deepview_data);
  });
});
