import type {
  DeepLinkData,
  DeepViewOptions,
  InitOptions,
  SessionData,
} from 'branch-sdk';
import { datatype, lorem } from 'faker';

export const generateDeepLinkData: () => DeepLinkData = () => ({
  channel: lorem.word(),
  data: { $always_deeplink: datatype.boolean(), $og_title: lorem.word() },
  feature: lorem.word(),
});

export const generateDeepViewOptions: () => DeepViewOptions = () => ({
  make_new_link: datatype.boolean(),
  open_app: datatype.boolean(),
});

export const generateInitOptions: () => InitOptions = () => ({
  metadata: { device_id: lorem.word() },
  no_journeys: datatype.boolean(),
  tracking_disabled: datatype.boolean(),
});

export const generateSessionData: () => SessionData = () => ({
  data_parsed: { device_id: datatype.uuid() },
  has_app: datatype.boolean(),
  identity: datatype.uuid(),
});
